function y = gsswitch(u);
%----------------------------------------------------------------
% GSSWITCH.m contains the switch-criterion for switching from
% Glideslope-Armed to Glideslope-Coupled.
%
% Inputsignal
% ===========
% u = [epsilon_gs(t) gsswitch_feedback]'
%
%     epsilon_gs is the angle between the nominal glide path and
%     the line from the aircraft's c.g. to the glideslope trans-
%     mitter [rad]
%
%     gsswitch_feedback is the previous output from gsswitch,
%     used to determine if the GS mode has been switched from
%     'Armed' to 'Coupled' already.
%
% Note: this function only works for glideslope intercepts from 
% below!
%
% Outputsignal
% ============
% y = flag variable, which determines if the Glideslope mode
%     is Armed (y = 1) or Coupled (y = -1)
%----------------------------------------------------------------

% Check switch-criterion only if the GS-mode is still in 'Armed' phase.
% ---------------------------------------------------------------------
if u(2)==1

   % Evaluate switch criterion for Glideslope mode. If the aircraft crosses 
   % the glideslope reference line from below, epsilon_gs changes from a 
   % negative value to a positive value. The mode will then switch to 'Coupled'
   % (and stay 'Coupled' thereafter). See refs.[1] and [2] for more details.
   % --------------------------------------------------------------------------
   if u(1) < 0
      y =  1; % remain Armed
   else
      y = -1; % switch to Coupled
   end

else
   y = -1; % stay Coupled
end

   
% References
% ==========
% [1]  M.O. Rauw, A SIMULINK environment for Flight Dynamics and
%      Control analysis - Application to the DHC-2 'Beaver',
%      PART II! MSc-thesis, Delft University of Technology, Faculty 
%      of Aerospace Engineering, Delft, 1993.
%
% [2]  P.N.H. Wever, Ontwerp en implementatie van de regelwetten
%      van de De Havilland DHC-2 'Beaver' (in Dutch). MSc-thesis,
%      Delft University of Technology, Faculty of Aerospace 
%      Engineering, Delft, 1993.

%-----------------------------------------------------------------------
% The Flight Dynamics and Control Toolbox version 1.4.0. 
% (c) Copyright Marc Rauw, 1994-2005. Licensed under the Open Software 
% License version 2.1; see COPYING.TXT and LICENSE.TXT for more details.
% Last revision of this file: December 31, 2004. 
%-----------------------------------------------------------------------